; Template file: QUERY.APL
; Type         : AreaMgr
;
; This template generates a six different lists:
;
; 1 - A list of all the fileechos a system only receives files in.
; 2 - A list of all the fileechos a system only sends files in,
; 3 - A list of all the fileechos a system both sends and receives files in.
; 4 - A list of all the conferences a system only receives files in.
; 5 - A list of all the conferences a system only sends files in,
; 6 - A list of all the conferences a system both sends and receives files in.
;
; Fileechos and conferences where the "Visible" option has been turned off
; (Default), will NOT be included in this list, unless the person is
; connected to them.
;
@assign(@bcount,0)
@assign(@count,0)
@assign(@doneheader,"No")
@areabegin
@test(@echostat,=,"+")
@test(@doneheader,=,"No")

  Your system receives files from our system for the following fileecho(s):

  Fileecho      Description                                Avg Kb   Avg Files
  ---------------------------------------------------------------------------
@assign(@doneheader,"Yes")
@end
  @just(@fileecho,L,14)@just(@echodesc,L,39) @just(@avgkb,R,9)   @just(@avgfiles,R,9)
@add(@count,1)
@add(@bcount,1)
@end
@end
@test(@doneheader,=,"Yes")
  ---------------------------------------------------------------------------
  @count fileecho(s)
@end
@assign(@count,0)
@assign(@doneheader,"No")
@areabegin
@test(@echostat,=,"*")
@test(@doneheader,=,"No")

  Our system receives files from your system for the following fileecho(s):

  Fileecho      Description                                Avg Kb   Avg Files
  ---------------------------------------------------------------------------
@assign(@doneheader,"Yes")
@end
  @just(@fileecho,L,14)@just(@echodesc,L,39) @just(@avgkb,R,9)   @just(@avgfiles,R,9)
@add(@count,1)
@add(@bcount,1)
@end
@end
@test(@doneheader,=,"Yes")
  ---------------------------------------------------------------------------
  @count fileecho(s)
@end
@assign(@count,0)
@assign(@doneheader,"No")
@areabegin
@test(@echostat,=,"&")
@test(@doneheader,=,"No")

  We both send files to each other for the following fileecho(s):

  Fileecho      Description                                Avg Kb   Avg Files
  ---------------------------------------------------------------------------
@assign(@doneheader,"Yes")
@end
  @just(@fileecho,L,14)@just(@echodesc,L,39) @just(@avgkb,R,9)   @just(@avgfiles,R,9)
@add(@count,1)
@add(@bcount,1)
@end
@end
@test(@doneheader,=,"Yes")
  ---------------------------------------------------------------------------
  @count fileecho(s)
@end
@test(@bcount,=,0)
  You are not connected to any fileechos.
@end
@assign(@bcount,0)
@assign(@count,0)
@assign(@doneheader,"No")
@confbegin
@test(@echostat,=,"+")
@test(@doneheader,=,"No")

  Your system receives mail from our system for the following conference(s):

  Conference    Description
  ---------------------------------------------------------------------------
@assign(@doneheader,"Yes")
@end
  @just(@conference,L,14)@just(@confdesc,L,39)
@add(@count,1)
@add(@bcount,1)
@end
@end
@test(@doneheader,=,"Yes")
  ---------------------------------------------------------------------------
  @count conference(s)
@end
@assign(@count,0)
@assign(@doneheader,"No")
@confbegin
@test(@echostat,=,"*")
@test(@doneheader,=,"No")

  Our system receives mail from your system for the following conferences(s):

  Conference    Description
  ---------------------------------------------------------------------------
@assign(@doneheader,"Yes")
@end
  @just(@conference,L,14)@just(@confdesc,L,39)
@add(@count,1)
@add(@bcount,1)
@end
@end
@test(@doneheader,=,"Yes")
  ---------------------------------------------------------------------------
  @count conference(s)
@end
@assign(@count,0)
@assign(@doneheader,"No")
@confbegin
@test(@echostat,=,"&")
@test(@doneheader,=,"No")

  We both send mail to each other for the following conference(s):

  Conference    Description
  ---------------------------------------------------------------------------
@assign(@doneheader,"Yes")
@end
  @just(@conference,L,14)@just(@confdesc,L,39)
@add(@count,1)
@add(@bcount,1)
@end
@end
@test(@doneheader,=,"Yes")
  ---------------------------------------------------------------------------
  @count conference(s)
@end
@test(@bcount,=,0)
  You are not connected to any echomail conferences.
@end

---
 * Origin: use %HELP for help using the AreaMgr in ALLFIX (@akatouse)
