(******************************************************************************)
(*                          ALLFIX sample procedures                          *)
(*    Copyright (C) 1992,98 Harms Software Engineering, all rights reserved   *)
(*                                                                            *)
(*                 All information in this documentation is                   *)
(*                  subject to change without prior notice                    *)
(******************************************************************************)

UNIT TYPES;

INTERFACE

Const MaxFileIDlen = 45;                        { maximum length of a line in a FILE_ID.DIZ file        }

      _announce   = $0001;                      { Attribute bits for the fileecho records (attrib)      }
      _replace    = $0002;
      _convertall = $0004;
      _passthru   = $0008;
      _dupecheck  = $0010;
      _fileidxxx  = $0020;
      _visible    = $0040;
      _tinysb     = $0080;
      _Security   = $0100;
      _NoTouch    = $0200;
      _SendOrig   = $0400;
      _AddGifSpecs= $0800;
      _VirusScan  = $1000;
      _UpdateMagic= $2000;
      _UseFDB     = $4000;
      _TouchAV    = $8000;
                                                { Attribute bits for the fileecho records (attrib2)     }
      _Unique     = $0001;
      _AutoAdded  = $0002;
      _ConvertInc = $0004;
      _CompUnknown= $0008;

      _SendTo      = $0001;                     { Attribute bits for the systems in the system list     }
      _ReceiveFrom = $0002;
      _PreRelease  = $0004;
      _Inactive    = $0008;
      _NoneStat    = $0010;
      _HoldStat    = $0020;
      _CrashStat   = $0040;
      _Mandatory   = $0080;

      _AdoptFile   = 1;                         { Magic filename types                                  }
      _ExecCommand = 2;
      _ForwardTo   = 3;
      _MoveToArea  = 4;
      _NoForward   = 5;
      _OtherPath   = 6;
      _UpdateAlias = 7;
      _CopyFile    = 8;
      _KeepNum     = 9;
      _HatchNew    = 10;
      _PickUpFile  = 11;
      _UnpackFile  = 12;
      _PassThruFile= 13;
      _DeleteFile  = 14;
      _ServiceReq  = 15;
      _SendOnFreq  = 16;

      _HOLD        = $0200;                     { Message status bits in the node manager               }
      _CRASH       = $0001;

      ExportSize   = 255;                       { Size of the systems list                              }

      IndexSize    = 8000;                      { Maximum number of records in the TOBEREP.IDX file     }

      TagLength = 40;                           { Maximum length of a fileecho tag                      }
      {$IFDEF OS2}
      FileNameLen = 255;                        { Maximum length of a filename                          }
      {$ELSE}
      FileNameLen = 12;
      {$ENDIF}

Type

  StringRecord   = array[0..2000] of char;

  Str12          = string[12];
  FileNameStr    = String[FileNameLen];
  FileEchoTagSTr = String[TagLength];

  MsgBaseType    = (Hudson,Pkt,Msg,EzyCom,Squish,Jam,PCBoard,WildCat,Null,_Netmail);

  pop_style      = (pop_normal, pop_postroad, pop_nettamer, pop_pmmail,
                    pop_uucp, pop_soup, pop_eudora, pop_ka9q, pop_mr2ice);

  FileAreasArray = Array[1..8000] of Byte;

  NetAddress = Record
    Zone, Net, Node, Point : word;
  end;

  ZoneNet = Record
    Zone, Net : word;
  end;

  ToBeRepIdx = record                           { TOBEREP.IDX file                                      }
    Group : byte;
    Offset: word;
  end;

  ToBeRepFix = record                           { TOBEREP.FIX file                                      }
    Fname     : FileNameStr;
    Fsize     : Longint;
    Fdate     : Longint;
    From,
    Origin    : NetAddress;
    Group     : Byte;
    Name      : String[40];
    Comment   : String[50];
    Replaces  : String[12];
    MagicName : String[20];
    Fcrc      : LongInt;
    Cost      : Real;
    UnitCost  : Real;
    UnitSize  : Byte;
    DescLen   : Word;
    Passthru  : Boolean;
    Extra     : Array[1..32] of Byte;
    Fdesc     : StringRecord;
  end;

  ExportEntry = Record
    Address: NetAddress;
    Status : byte;
  end;

  ExportArray = Array[1..ExportSize] of ExportEntry; { Systems list                                     }

  GroupArray = Array[0..31] of byte;            { Array used to store groups                            }

  ArcRecord = Record
    Arc      : String[60];
    UnArc    : String[60];

    ArcCmd   : String[20];        { Used for unpacking normal archives }
    UnArcCmd : String[20];
    BannerCmd: String[20];
    SigOfs   : Word;
    UnArcCmd2: String[18];        { Used for unpacking TIC archives    }

    Ext      : String[03];
    Sig      : String[29];
  End;

  Ptr2ExternalProgramRec = ^ExternalProgramRec;
  ExternalProgramRec = Record
    Archivers : Array[1..10] of ArcRecord;
    GUS       : Record
                  Exe : String[60];
                  Opts: String[128];
                end;
    Scan      : Record
                  Exe : String[60];
                  Opts: String[128];
                end;
    EAC       : Record
                  Exe : String[60];
                  Opts: String[128];
                end;
    Editor    : String[60];

    Extra     : Array[1..105] of byte;
  end;


  UplinkRec = Record
    Aka         : NetAddress;
    MgrProgram  : String[8];
    MgrPassword : String[16];
    Attrib      : word;
    (* bit 0 - add prefix
       bit 1 - unconditional
       bit 2 - direct
       bit 3 - filebone.ra *)
    Groups      : GroupArray;
    AreasFile   : String[12];
    UseAka      : Byte;
  end;

  AkaMatchRec = Record
    Zn : ZoneNet;
    Aka: byte;
  end;

  MailerModeType = (FrontDoorMode,BinkleyMode,DBridgeMode,PortalOfPower);
  DateType       = (European     {dd-mm-yy},
                    American     {mm-dd-yy},
                    Scandinavian {yy-mm-dd});

Type

  ALLFIXcfg = Record                            { SETUP.FIX file                                        }
    VersionID     : Byte;
    WcBBSpath,
    inNETmail,
    MSGpath,
    Inbound,
    LOGfile       : string[60];
    PktPath       : String[60];
    PktOut        : String[60];
    Queue         : String[60];
    TicPath       : String[60];
    Alias         : String[60];       { Unlisted alias file }
    EchoSemaphore : String[60];
    RcvdPath      : String[60];
    FixLogFile    : String[60];
    BadPath       : String[60];
    AreaLog       : String[60];
    OutBound      : String[60];
    OutNetmail    : String[60];
    SecInbound    : String[60];

    SysOp         : string[30];
    RKeyDos       : String[24];
    ListPath      : string[60];
    BBSname       : string[30];
    Baud          : String[5 ];
    Flags         : String[30];
    Location      : String[30];
    Comment       : String[60];
    Pline1,
    Pline2,
    Pline3        : String[30];
    Marker        : Array[0..0] of byte;     {marker for cleaning action}

    RKeyWC,
    RKeyOS2       : String[24];

    Ptr2External  : Ptr2ExternalProgramRec;
    ExternalDOS   : ExternalProgramRec;
    ExternalOS2   : ExternalProgramRec;

    Internet      : Record
      Addrs         : String[60];
      InBox,                                  { where incoming emails are stored                }
      OutBox,                                 { where outgoing emails are stored                }
      SentBox       : String[60];             { where sent emails are stored, till acknowledged }
      Style         : pop_style;              { type of outbound files to create                }
      Ext           : String[3];              { SMTP file extension to use                      }
      NextSubMsgId  : LongInt;                { counter for msg sub ids                         }
      MessageSize   : Byte;                   { maximum value (and default) is 16kb             }
      ResendRate    : Byte;                   { num days to wait befor resend (default = 2)     }
      MaxRetry      : Byte;                   { max times to retry sending (default = 3)        }
      UUCP_sitename,                          { UUCP site name                                  }
      UUCP_hostname : string[30];             { UUCP host name                                  }
      MaxSpoolAge   : Byte;                   { Maximum number of days to keep chunks in spool  }
      OutExt        : string[3];              { extension to use on outbound emails             }
      RouteNetmail  : boolean;
    end;

    NotUsed6      : array[1..1321] of byte;

    ALLFIXversion : word;
    ALLFIXbuild   : byte;
    RkeyUNI       : String[24];
    FakeAka       : NetAddress;
    BadTics,
    DupeTics      : String[60];
    TicArchiveSpecs: String[40];
    Notused0      : array[1..5] of byte;
    Origin        : array[1..20] of String[60];
    Days          : array[1..7 ] of String[20];
    Months        : array[1..12] of String[20];

    Domains       : array[1..40] of Record Zone: Word;Name: String[25]; end;
    Notused       : array[1..50+530] of byte;

    UplinkOpts    : record
      RRrate      : byte;
      RRtimes     : byte;
      AutoRemove  : boolean;
      AAdelay     : byte;
    end;
    Uplink        : Array[1..20] of UplinkRec;

    KeepDate      : Boolean;
    Rescan        : Byte;
    KeepNet,
    KeepRec       : Boolean;
    Swap          : Byte;
    Exclude       : Array[1..20] of String[12];
    FileCnt       : String[8];
    Os2Priority   : ShortInt;

    FilterAnsi    : Boolean;

    NodesDef      : Record
      Useaka      : Byte;
      FileStat    : Byte;
      AreaMgrStat : Byte;
      TicFile     : Byte;
      Message     : Boolean;
      Notify      : Boolean;
      Archiver    : Byte;
      Forward,
      AutoAdd     : Boolean;
      PackMode    : Byte;
      Remote      : Boolean;
      Groups      : GroupArray;
      Extra1      : Array[1..44] of byte;
    end;

    LogStyle      : byte;
    LocalRep      : Boolean;
    LogOptions    : Longint;
    AkaMatch      : Array[1..20] of AkaMatchRec;
    ReplaceExt    : Boolean;
    KeepMgr       : Boolean;
    AreaMgrOpts   : Word;
      { bit 0 - allow %+ALL
             1 -       %notify
             2 -       %password
             3 -       %message
             4 -       %compression
             5 -       %tick
             6 -       %pause
             7 -       %echopassword
             8 -       %pack }
    AutoAddNodes  : Boolean;
    PublicGroups  : GroupArray;
    UseXEMS       : Boolean;
    MailerMode    : MailerModeType;
    DaysToKeepHis : Byte;
    MaxSizeOfHis  : Byte;
    FEnumSystems  : Byte;
    ExtendedChar  : Char;
    FilterFileID  : Byte;     { 0 - none, 1 - high ascii, 2 - carriage returns }
    OneLineFileID : Boolean;
    KeepDays      : Word;
    DateFormat    : DateType;
    StatSize      : Word;
    _4DOSmode     : Boolean;
    AreaMgrStr    : Array[1..5] of String[20];
    NotUsed10     : Array[0..63] of byte;
    DBqueue       : String[60];
    TagPath       : String[60];
    AutoCleanUp   : Boolean;
    SortByGroup   : Boolean;
    notused4      : array[1..30] of byte;
    RedirectOutput: Boolean;
    VirusErrorLvl : Byte;
    FilesToScan   : Byte;
    MaxLineFileID : Byte;
    FileIDindent  : Byte;
    InitDate      : Longint;
    EchoToss      : String[60];
    MaxTicPackSize: Word;
    OldFileFind   : Byte;
    TmpDir        : String[60];
    NotUsed11     : Array[0..141] of byte;
    AddArea       : Byte;
    TemplatePath  : String[60];
    UTCofs        : Integer;
    MtaVirusLvl,
    MtaErrorLvl   : Byte;
    MinSpace      : Word;
    Colors        : String[40];
    FileBox       : String[60];
    NotUsed8      : Array[0..60] of byte;
    RpLog         : String[60];
    FilterStr1    : String[20];
    FilterStr2    : String[20];
    FilterStr3    : String[20];
    OS2RpPriority : byte;
    InvalidFloExt : String[3];
    notused5      : array[1..5] of byte;
    DupeCheck     : Byte;
      {  0 - filename
         1 - filename + fileecho
         2 - filecrc
         3 - filecrc + fileecho
         4 - filecrc + filename
         5 - filename + fileecho + filecrc }
    MaxSizeToPack : Word;
    messagecomp   : byte;
    BillPath      : String[60];
    DupePath      : String[60];
    NotUsed9      : Array[0..491] of byte;
    Unwanted      : String[60];
    MaxMsgSize    : Byte;
    OldBillsPath  : String[60];
    InvoiceNr     : LongInt;
    AddToArchive  : String[60];
    Semaphore     : String[60];
    LongDescWidth : Byte;
    NotUsed7      : Array[0..141] of byte;
    __Wc_AddOrig  : Boolean;
    SFImode       : Boolean;
    Aka           : array[0..40] of NetAddress;
    RP            : Record
      Groups,
      SecGroups   : GroupArray;
      IntReport,
      Report      : String[8];
      MaxFiles,
      MaxSize     : Word;
      List,
      SecList     : string[60];

      Active      : Boolean;

      UknList     : string[60];
      UknGroups   : GroupArray;
      SecMaxFiles,
      SecMaxSize,
      UknMaxFiles,
      UknMaxSize  : word;
      UnSecAlias,
      SecAlias    : string[60];
      FlagMode    : byte;
      MaxTime,
      UknMaxTime,
      SecMaxTime  : byte;
      CcToSysop   : boolean;
      IntMaxFiles,
      IntMaxSize  : word;
      Extra       : Array[1..11] of byte;
    end;
  end;


  AreaMGRRec = Record                           { AREAS.FIX file                                        }
     Comment : string[55];
     Name    : string[40];
     RName   : String[40];
     Origin  : byte;
     Board   : Word;                            { Scan board number                                     }
     RBoard  : Word;                            { Reply board number                                    }
     Aka     : byte;
     Path    : String[60];                      { Scan path                                             }
     Rpath   : String[60];                      { Reply path                                            }
     Btype,                                     { Scan type of message base                             }
     Rtype   : byte;                            { Reply type of message base                            }
     _Sname  : String[8];                       { no longer used                                        }
     _SRname : String[8];                       { no longer used                                        }
     Template: String[8];
     Inactive: Boolean;
     MaxFilesInReply : byte;
     FileAreas       : FileAreasArray;
     Extra           : Array[1..103] of byte;
   end;

   AreaMgrIdx = Record                          { AREAS.IDX file                                        }
     Comment : String[55];
     Offset  : Word;
   End;

   NewFileMgrRec = Record                       { NEWFILES.FIX file                                     }
     Comment  : String[55];
     Group    : Byte;
     FileAreas: FileAreasArray;
   end;

   NewFileMgrIdx = Record                       { NEWFILES.IDX file                                     }
     FileBrd: Word;
     Comment: String[55];
     Offset : Word;
   End;

   FileMGRrec = Record                          { FAREAS.FIX file                                       }
     Name      : FileEchoTagStr;
     Message   : String[12];
     Comment   : String[55];
     Group     : Byte;
     Attrib    : word;
     KeepLate  : ShortInt;
     Convert   : 0..10;
     UplinkNum : Byte;
     DestDir   : String[60];
     TotalFiles,
     TotalKb   : Word;
     Byear,
     Bmonth    : Byte;
     _FBoard   : Word;
     UseAka    : ShortInt;
     LongDesc  : Byte;
     Banner    : String[8];
     UnitCost     : real;
     UnitSize     : byte;
     DivCost      : byte;
     AddPercentage: real;
     IncludeRcost : boolean;
     Attrib2      : word;
     PurgeSize,
     PurgeNum,
     PurgeAge     : word;
     BBSmask      : word;
     RAID         : Record
       Level       : Word;
       Distribution: Byte;
       hAllowed    : Byte;
       rChannel    : Boolean;
     end;
     Extra        : array[1..14] of byte;
     Export       : ExportArray;
   end;

   FileMGRidx = Record                          { FAREAS.IDX file                                       }
     Name   : FileEchoTagStr;
     Group  : Byte;
     Offset : word;
   end;

   GrpFileMgrRec = Record                       { GRPFILE.FIX file                                      }
     FMrec : FileMgrRec;
     Name  : String[25];
   end;

   GrpFileMgrIdx = Record                       { GRPFILE.IDX file                                      }
     Group     : Byte;
     Spec      : FileEchoTagStr;
     Name      : String[25];
     UplinkNum : Byte;
     Offset    : Word;
   end;

   NodeMGRrec = Record                          { NODEFILE.FIX file                                     }
     Aka           : NetAddress;
     Sysop         : String[35];
     Password      : String[20];
     Groups        : GroupArray;
     Reserved      : Byte;
     Inactive      : Boolean;
     RepNewEchos   : Boolean;
     CopyOther     : Boolean;
     SendTicWFreq  : Boolean;
     FileStat      : Byte;
     AreaMgrStat   : Byte;
     TicFile       : Byte;
     UseAka        : ShortInt;
     Message       : Boolean;
     Notify        : Boolean;
     Archiver      : Byte;
     Forward       : Boolean;
     AutoAdd       : Boolean;
     MgrPassword   : String[20];
     Remote        : Boolean;
     PackMode      : Byte;
     ViaNode       : NetAddress;
     Billing       : Byte;
     BillGroups    : GroupArray;
     Credit,
     WarnLevel,
     StopLevel     : real;
     SendBill      : byte;
     SendDay       : byte;
     AddPercentage : real;
     BillSent      : word;
     SystemPath    : String[60];
     MembershipFee : Real;
     PktPassword   : String[8];
     Internet      : String[60];
     EnableInternet: Byte;
     GateWay       : Byte;
     EncodeFreqs   : Boolean;
     GateWhat      : Byte;
       { bit 1 - Crash mail
         bit 2 - Hold mail }
     Extra2        : array[1..44] of byte;
   end;

   NodeMGRidx = Record                          { NODEFILE.IDX file                                     }
     Aka   : NetAddress;
     Offset: word;
   end;

   ReportsMgrRec = Record                       { REPORTS.FIX file                                      }
     Groups   : GroupArray;
     Reserved : Byte;
     Inactive : Boolean;
     Extra    : Array[1..3] of byte;
     Aka      : byte;
     Origin   : byte;
     Template : String[8];
     From,
     Too      : String[35];
     Subject  : String[72];
     MsgType  : byte;                           { Message base type                                     }
     Board    : Word;                           { Message board number                                  }
     Name     : String[40];
     Path     : String[60];
     Export   : ExportArray;
     Extra2   : Array[1..44] of byte;
   end;

   ReportsMGRidx = Record                       { REPORTS.IDX file                                      }
     Group    : GroupArray;
     Inactive : Boolean;
     Offset   : Word;
   end;

   MagicFileMgrRec = Record                     { MGICFILE.FIX file                                     }
     Attrib   : Byte;
     FileMask,
     FromArea,
     ToArea   : FileEchoTagStr;
     Directory: String[60];
     Command  : String[60];
     KeepNum  : ShortInt;
     Days     : Byte;
     NewTask  : Byte;
     Extra    : Array[1..40] of byte;
     Export   : ExportArray;
   end;

   MagicMGRidx = Record                         { MGICFILE.IDX file                                     }
     FileMask : String[12];
     Attrib   : Byte;
     Offset   : Word;
   end;

   HatchMGRrec = Record                         { HATCH.FIX file                                        }
     Name        : FileEchoTagStr;
     Spec        : String[79];
     Replace     : String[12];
     Magic       : String[20];
     Desc        : String[80];
     Days        : Byte;
     AlwaysHatch : Boolean;
     Extra       : Array[1..4] of byte;
   end;

   HatchMgrIdx = Record                         { HATCH.IDX file                                        }
     Name: FileEchoTagStr;
     Offset: word;
   end;

   AllfilesMgrRec = Record
     Tag       : FileEchoTagStr;
     Template  : string[8];
     Age       : word;
     filename  : string[60];
     FileAreas : FileAreasArray;
     Extra     : array[1..79] of byte;
   end;

   AllfilesMgrIdx = Record
     Tag       : FileEchoTagStr;
     Offset    : word;
   end;

   FileAreaRecord = Record                      { FILEAREA.FIX file (file area records)                 }
     Path   : string[60];
     Name   : string[80];
     List   : string[60];
     Fnum   : string[9];
     Fbrd   : Word;
     Pbrd   : Word;
     PathCRC: LongInt;
     Fofs   : LongInt;
     Sofs   : LongInt;
     Attrib : Byte;
       { bit 0 - CDROM area
         bit 1 - Force FILES.BBS }
   end;

   FileAreaHeader = Record                      { FILEAREA.FIX file (header, stored at begining of file)}
     BBStype   : byte;
     SysPath   : String[60];
     BBSpath   : String[60];
     FilePath  : String[60];
     ParentFile: String[60];
     UseFDB    : boolean;
     LastSize  : LongInt;
     aBBStype  : byte;
     HighArea  : word;
     Data1     : word;
     Data2     : word;
     Extra     : Array[1..255] of byte;
   end;

  StatisticRecord = Record                      { STATFILE.FIX file                                     }
    FileEcho : FileEchoTagStr;
    Date     : Longint;
    FileName : Str12;
    FileSize : Longint;
    FileDate : Longint;
    Sender   : NetAddress;
    NumDown  : Word;                            { Number of downlinks following this record             }
  end;

  StatisticIndex = Record                       { STATFILE.IDX file                                     }
    FileEcho : Longint;                         { 32 bit CRC of fileecho name                           }
    Offset   : Longint;
  end;

IMPLEMENTATION

end.
